// OContainerView.cpp : implementation of the COContainerView class
//

#include "stdafx.h"
#include "OContainer.h"

#include "OContainerDoc.h"
#include "CntrItem.h"
#include "OContainerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// COContainerView

IMPLEMENT_DYNCREATE(COContainerView, CView)

BEGIN_MESSAGE_MAP(COContainerView, CView)
	ON_WM_DESTROY()
	ON_WM_SETFOCUS()
	ON_WM_SIZE()
	ON_COMMAND(ID_OLE_INSERT_NEW, &COContainerView::OnInsertObject)
	ON_COMMAND(ID_CANCEL_EDIT_CNTR, &COContainerView::OnCancelEditCntr)
	ON_COMMAND(ID_FILE_PRINT, &COContainerView::OnFilePrint)
    ON_COMMAND(ID_FILE_ZAKO32771, &COContainerView::OnFileZakoncz)
    ON_COMMAND(ID_FILE_EDYTUJ32774, &COContainerView::OnFileEdytuj)
    ON_COMMAND(ID_FILE_OTWORZ, &COContainerView::OnFileOtworz)
    ON_COMMAND(ID_FILE_WSTAWDOKUMENTWORD, &COContainerView::OnFileWstawdokumentword)
    ON_COMMAND(ID_FILE_WSTAWDOKUMENTWORDZPLIKU32779, &COContainerView::OnFileWstawdokumentwordzpliku)
END_MESSAGE_MAP()

// COContainerView construction/destruction

COContainerView::COContainerView()
{
	m_pSelection = NULL;
	// TODO: add construction code here

}

COContainerView::~COContainerView()
{
}

BOOL COContainerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

void COContainerView::wstawObiekt(CString objName, CString fileName)
{
	m_pSelection = NULL;

	BeginWaitCursor(); // Poinformowanie uytkownika o specjalnych okolicznociach

	COContainerCntrItem* pItem = NULL;
	try
	{
		COContainerDoc* pDoc = GetDocument();
		CLSID clsid;
		ASSERT_VALID(pDoc);
		pItem = new COContainerCntrItem(pDoc);
		ASSERT_VALID(pItem);

        // Obiekt z pliku czy z rejestru
        if(fileName == "")
        {
            CLSIDFromProgID(objName, &clsid);
            if (!pItem->CreateNewItem(clsid))
            	AfxThrowMemoryException();  // wystarczy dowolny wyjtek
        }
        else
        {
            if (!pItem->CreateFromFile(fileName))
            	AfxThrowMemoryException();  
            
        }
		ASSERT_VALID(pItem);
		m_pSelection = pItem;   
		pDoc->UpdateAllViews(NULL);
	}
	catch(CException* e)
	{
		if (pItem != NULL)
		{
			ASSERT_VALID(pItem);
			pItem->Delete();
		}
		e->ReportError();
		e->Delete();
	}
	
	EndWaitCursor(); // koniec specjalnych okolicznoci
}


// COContainerView drawing

void COContainerView::OnDraw(CDC* pDC)
{
	if (!pDC)
		return;

	COContainerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	// TODO: add draw code for native data here
	// TODO: also draw all OLE items in the document

	// Draw the selection at an arbitrary position.  This code should be
	//  removed once your real drawing code is implemented.  This position
	//  corresponds exactly to the rectangle returned by COContainerCntrItem,
	//  to give the effect of in-place editing.

	// TODO: remove this code when final draw code is complete.
	if (m_pSelection != NULL)
	{
		CSize size;
		CRect rect(10, 10, 210, 210);
		
		if (m_pSelection->GetExtent(&size, m_pSelection->m_nDrawAspect))
		{
			pDC->HIMETRICtoLP(&size);
			rect.right = size.cx + 10;
			rect.bottom = size.cy + 10;
		}
		m_pSelection->Draw(pDC, rect);
	}
}

void COContainerView::OnInitialUpdate()
{
	CView::OnInitialUpdate();

	// TODO: remove this code when final selection model code is written
	m_pSelection = NULL;    // initialize selection
	
	wstawObiekt(L"Paint.Picture");
}

void COContainerView::OnDestroy()
{
	// Deactivate the item on destruction; this is important
	// when a splitter view is being used
   COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
   if (pActiveItem != NULL && pActiveItem->GetActiveView() == this)
   {
      pActiveItem->Deactivate();
      ASSERT(GetDocument()->GetInPlaceActiveItem(this) == NULL);
   }
   CView::OnDestroy();
}



// OLE Client support and commands

BOOL COContainerView::IsSelected(const CObject* pDocItem) const
{
	// The implementation below is adequate if your selection consists of
	//  only COContainerCntrItem objects.  To handle different selection
	//  mechanisms, the implementation here should be replaced

	// TODO: implement this function that tests for a selected OLE client item

	return pDocItem == m_pSelection;
}

void COContainerView::OnInsertObject()
{
	// Invoke the standard Insert Object dialog box to obtain information
	//  for new COContainerCntrItem object
	COleInsertDialog dlg;
	if (dlg.DoModal() != IDOK)
		return;

	BeginWaitCursor();

	COContainerCntrItem* pItem = NULL;
	TRY
	{
		// Create new item connected to this document
		COContainerDoc* pDoc = GetDocument();
		ASSERT_VALID(pDoc);
		pItem = new COContainerCntrItem(pDoc);
		ASSERT_VALID(pItem);

		// Initialize the item from the dialog data
		if (!dlg.CreateItem(pItem))
			AfxThrowMemoryException();  // any exception will do
		ASSERT_VALID(pItem);
		
        if (dlg.GetSelectionType() == COleInsertDialog::createNewItem)
			pItem->DoVerb(OLEIVERB_SHOW, this);

		ASSERT_VALID(pItem);
		// As an arbitrary user interface design, this sets the selection
		//  to the last item inserted

		// TODO: reimplement selection as appropriate for your application
		m_pSelection = pItem;   // set selection to last inserted item
		pDoc->UpdateAllViews(NULL);
	}
	CATCH(CException, e)
	{
		if (pItem != NULL)
		{
			ASSERT_VALID(pItem);
			pItem->Delete();
		}
		AfxMessageBox(IDP_FAILED_TO_CREATE);
	}
	END_CATCH

	EndWaitCursor();
}

// The following command handler provides the standard keyboard
//  user interface to cancel an in-place editing session.  Here,
//  the container (not the server) causes the deactivation
void COContainerView::OnCancelEditCntr()
{
	// Close any in-place active item on this view.
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL)
	{
		pActiveItem->Close();
	}
	ASSERT(GetDocument()->GetInPlaceActiveItem(this) == NULL);
}

// Special handling of OnSetFocus and OnSize are required for a container
//  when an object is being edited in-place
void COContainerView::OnSetFocus(CWnd* pOldWnd)
{
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL &&
		pActiveItem->GetItemState() == COleClientItem::activeUIState)
	{
		// need to set focus to this item if it is in the same view
		CWnd* pWnd = pActiveItem->GetInPlaceWindow();
		if (pWnd != NULL)
		{
			pWnd->SetFocus();   // don't call the base class
			return;
		}
	}

	CView::OnSetFocus(pOldWnd);
}

void COContainerView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL)
		pActiveItem->SetItemRects();
}

void COContainerView::OnFilePrint()
{
	//By default, we ask the Active document to print itself
	//using IOleCommandTarget. If you don't want this behavior
	//remove the call to COleDocObjectItem::DoDefaultPrinting.
	//If the call fails for some reason, we will try printing
	//the docobject using the IPrint interface.
	CPrintInfo printInfo;
	ASSERT(printInfo.m_pPD != NULL); 
	if (S_OK == COleDocObjectItem::DoDefaultPrinting(this, &printInfo))
		return;
	
	CView::OnFilePrint();

}



// COContainerView diagnostics

#ifdef _DEBUG
void COContainerView::AssertValid() const
{
	CView::AssertValid();
}

void COContainerView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

COContainerDoc* COContainerView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(COContainerDoc)));
	return (COContainerDoc*)m_pDocument;
}
#endif //_DEBUG


// COContainerView message handlers

void COContainerView::OnFileZakoncz()
{
    //konczenie edycji
    COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
    if(pActiveItem != NULL)
        pActiveItem->Close();
}

void COContainerView::OnFileEdytuj()
{
    m_pSelection->DoVerb(OLEIVERB_SHOW, this);
}

void COContainerView::OnFileOtworz()
{
    m_pSelection->DoVerb(OLEIVERB_OPEN, this);   
}


void COContainerView::OnFileWstawdokumentword()
{
    wstawObiekt(L"Word.Document");
}

void COContainerView::OnFileWstawdokumentwordzpliku()
{
    CFileDialog fileDialog(TRUE, 0, 0, 2, L"Dokumenty Worda (*.doc)|*.doc||");
    if(fileDialog.DoModal() != IDCANCEL)
        wstawObiekt(NULL, fileDialog.GetPathName());
    else
        MessageBox(L"Anulowano wstawienie dokumentu");
}

